/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

public class ToolBar extends Composite {

public ToolBar (Composite parent, int style) {
	super (parent, checkStyle (style));
}

static int checkStyle (int style) {
//TODO 
//	TEMPORARY CODE	
	if (style==SWT.NONE) {
		return checkBits (style, SWT.HORIZONTAL, SWT.VERTICAL, 0, 0, 0, 0);
	}
	return  style;
}

protected void checkSubclass () {
}

public Point computeSize (int wHint, int hHint, boolean changed) {
//TODO make use of changed
	Rectangle rectangle = getNativeBounds();
	int width = rectangle.width;
	int height = rectangle.height;
	if (wHint != SWT.DEFAULT) width = wHint;
	if (hHint != SWT.DEFAULT) height = hHint;
	return new Point (width, height);
}

public ToolItem getItem (int index) {
	return null;
}

public ToolItem getItem (Point point) {
	return null;
}

public int getItemCount () {
	return 0;
}

public ToolItem[] getItems () {
	return null;
}

public int getRowCount () {
	return 0;
}

public int indexOf (ToolItem item) {
	return 0;
}

public void setFont (Font font) {
}

public boolean setParent (Composite parent) {
	return false;
}

public void setRedraw (boolean redraw) {
}

/*---------------- NATIVE INTERFACE ----------------*/

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.ToolBar"]){
		$wnd.dojo._hasResource["org.eclipse.swt.ToolBar"] = true;
		$wnd.dojo.provide("org.eclipse.swt.ToolBar");
		
		$wnd.dojo.require("dijit.Toolbar");
	
		$wnd.dojo.declare("org.eclipse.swt.ToolBar", $wnd.dijit.Toolbar, {
			postCreate: function(){
				this.inherited("postCreate", arguments);
				$wnd.swt.setCssStyle(this.domNode, {
					overflowX: "hidden",
					overflowY: "hidden"
				});
			},
			resize: function(){},
		});
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var params = {};
	if((style & (@org.eclipse.swt.SWT::NONE | @org.eclipse.swt.SWT::BORDER)) != 0) {
	}
	if((style & (@org.eclipse.swt.SWT::HORIZONTAL)) != 0) {
		$wnd.console.log("h");
	} else if((style & (@org.eclipse.swt.SWT::VERTICAL)) != 0) {
		$wnd.console.log("v");
	}
	var self = new $wnd.org.eclipse.swt.ToolBar(params);
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

}
